Attribute VB_Name = "MNT_SHW"
'########################################################################################################
'########################################################################################################
'########################################################################################################


Dim XXXfoc_fly As Double, YYYfoc_fly As Double, ZZZfoc_fly As Double '........ RaumKoordinaten FocusPunkt
Dim DSTobs_foc As Long '.................................................. Entfernung Observer-FocusPunkt
Dim DSTofc_pxz As Long '...................................... Projektion von DSTobs_foc auf die XZ-Ebene
Dim ALPobs_foc As Double '........................................................... Winkel zur YZ-Ebene
Dim GMAobs_foc As Double '........................................................... Winkel zur XZ-Ebene


Dim XXXfly_geo As Double, ZZZfly_geo As Double, YYYfly_geo As Double '................. ResultKoordinaten
Dim XXXobs_fly As Double, YYYobs_fly As Double, ZZZobs_fly As Double '.................. ObserverPosition
Dim WDTfoc_fly As Long '...................................................................... BrennWeite
Dim LFTscc_fly As Long, TOPscc_fly As Long '........... AbbildungsKoordinaten des BildschirmMittelpunktes

Dim DSThrz_mnt As Long '.................................................... Entfernung der HorizontLinie
Dim LFThrz_img As Double '................................................... Position des HorizontImages
Dim LFThrz_stp As Double '........................................ Horizontale Verschiebung des Horizonts


'................................................................................. START-STELLE/STATIONEN
Dim LFTstc_loc() As Long, TOPstc_loc() As Long '..................... AbbildungsKoordinaten der Stationen
Dim LFTstc_nbr() As Long, TOPstc_nbr() As Long '............ AbbildungsKoordinaten der StationsBezeichner

'....................................................................... ABSTANDS-LINIEN ZUR START-STELLE
Dim STPdst_pnt As Integer '.... Entfernung der Punkte der AbstandsLinien der MeStationen zur StartStelle
Dim NBRdpt_max As Integer '..................................... Anzahl Punkte der lngsten AbstandsLinie
Dim NBRdst_pnt() As Integer '.............................. Anzahl Punkte der AbstandsLinie der Stationen
Dim LFTdst_pnt() As Long, TOPdst_pnt() As Long '................................... AbbildungsKoordinaten

'.................................................................. VERBINDUNGS-LINIEN DER MESS-STATIONEN
Dim NBRspt_max As Integer '.................................. Anzahl Punkte der lngsten VerbindungsLinie
Dim NBRstc_pnt() As Integer '........................................ Anzahl Punkte der VerbindungsLinien
Dim LFTstc_pnt() As Long, TOPstc_pnt() As Long '................................... AbbildungsKoordinaten

'.............................................................................................. FLUG-BAHN
Dim TMPxxx_spc%(), TMPzzz_spc%(), TMPyyy_spc%()
Dim NBRfly_pnt As Integer
Dim XXXfly_pnt() As Double
Dim ZZZfly_pnt() As Double
Dim YYYfly_pnt() As Double

Dim LFTfly_pnt() As Long '............................................. Horizontale AbbildungsKoordinaten
Dim TOPfly_pnt() As Long '............................................... Vertikale AbbildungsKoordinaten


'........................................................................................ PEILUNGS-LINIEN
Dim XXXvsl_end() As Double, YYYvsl_end() As Double, ZZZvsl_end() As Double '... RaumKoordinaten EndPunkte
Dim STPvsl_pnt As Integer '..................................... Entfernung der Punkte der PeilungsLinien
Dim NBRvsl_pnt() As Integer '........................................... Anzahl Punkte der PeilungsLinien
Dim NBRvpt_max As Integer '.................................... Anzahl Punkte der lngsten PeilungsLinien
Dim LFTvsl_pnt() As Long, TOPvsl_pnt() As Long '..... AbbildungsKoordinaten der Punkte der PeilungsLinien







'********************************************************************************************************
'***************************** AUSRICHTEN DES OBSERVERS AUF DEN FOCUS-PUNKT *****************************
'
   Sub MntShwClcObsDirection()
'
'........................................................................................................

   
'...................................................... Relative Koordinaten des Observers zum FocusPunkt
DXomp# = XXXfoc_fly - XXXobs_fly: DYomp# = YYYfoc_fly - YYYobs_fly: DZomp# = ZZZfoc_fly - ZZZobs_fly

'...................................... Projektion der AbstandsLinie Observer-FocusPunkt auf die XZ-Ebene
DSTofc_pxz = Sqr(DXomp# * DXomp# + DZomp# * DZomp#)

  '.................................................................................. Winkel zur YZ-Ebene
  If DXomp# <> 0 Then
    TAmxz# = DZomp# / DXomp#
    ALPobs_foc = Atn(TAmxz#)
    
      If DXomp# < 0 Then
        If DZomp# <> 0 Then
          ALPobs_foc = Sgn(DZomp#) * Pi180 + ALPobs_foc
        Else
          ALPobs_foc = Pi180 + ALPobs_foc
        End If
      End If
      
  Else
    ALPobs_foc = Sgn(DZomp#) * Pi090
  End If


  '.................................................................................. Winkel zur XZ-Ebene
  If DSTofc_pxz <> 0 Then
    TGfnt# = DYomp# / DSTofc_pxz
    GMAobs_foc = Atn(TGfnt#)
  Else
    GMAobs_foc = Sgn(DYomp#) * Pi090
  End If

'............................................................................ Abstand Observer-FocusPunkt
DSTobs_foc = Sqr(DSTofc_pxz * DSTofc_pxz + DYomp# * DYomp#)

       
'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'*********************** BERECHNUNG DER SPHRISCHEN ABBILDUNG EINES RAUMPUNKTES *************************
'
   Sub MntShwClcDrwPosition(XX#, YY#, ZZ#, LFTx&, TOPx&)
'
'                                                        Beachten bei Verwendung von SGN:  Sgn(0) = 0 !!!
'
'                      - Nicht anwendbar auf Punte hinter der ObserverPosition -
'........................................................................................................

   
'................................................................ Relative Koordinaten Observer-RaumPunkt
DXspc# = XX# - XXXobs_fly: DYspc# = YY# - YYYobs_fly: DZspc# = ZZ# - ZZZobs_fly
   
  '.................................................... HorizontalWinkel zur vertikalen AusrichtungsEbene
  If DXspc# <> 0 Then
    TApxz# = DZspc# / DXspc#
    ALPpxz# = Atn(TApxz#)
    
      If DXspc# < 0 Then
      
        If DZspc# <> 0 Then
          ALPpxz# = Sgn(DZspc#) * Pi180 + ALPpxz#
        Else
          ALPpxz# = Pi180 + ALPpxz#
        End If
      End If
    
  Else
    ALPpxz# = Sgn(DZspc#) * Pi090
  End If

ALPspc# = ALPpxz# - ALPobs_foc
If Abs(ALPspc#) > Pi180 Then ALPspc# = ALPspc# - Sgn(ALPspc#) * Pi360

DSTpxz# = Sqr(DXspc# * DXspc# + DZspc# * DZspc#)
DXAspc# = DSTpxz# * Cos(ALPspc#)
DZAspc# = DSTpxz# * Sin(ALPspc#)
DSTpxy# = Sqr(DXAspc# * DXAspc# + DYspc# * DYspc#)


  If DSTpxy# <> 0 Then
    TAdrw# = DZAspc# / DSTpxy#
    ALPdrw# = Atn(TAdrw#)
  Else
    ALPdrw# = Sgn(DZAspc#) * Pi090
  End If


  '.................................................... VertikalWinkel zur horizontalen AusrichtungsEbene
  If DXAspc# <> 0 Then
    TGpxy# = DYspc# / DXAspc#
    GAMpxy# = Atn(TGpxy#)
         
      If DXAspc# < 0 Then
        If DYspc# <> 0 Then
          GAMpxy# = GAMpxy# + Sgn(DYspc#) * Pi180
        Else
          GAMpxy# = GAMpxy# + Pi180
        End If
      End If
         
  Else
    GAMpxy# = Sgn(DYspc#) * Pi090
  End If


GAMspc# = GAMpxy# - GMAobs_foc
If Abs(GAMspc#) > Pi180 Then GAMspc# = GAMspc# - Sgn(GAMspc#) * Pi360

DSTpxy# = Sqr(DXAspc# * DXAspc# + DYspc# * DYspc#)
DXGspc# = DSTpxy# * Cos(GAMspc#)
DYGspc# = DSTpxy# * Sin(GAMspc#)
DSTpxz# = Sqr(DXGspc# * DXGspc# + DZAspc# * DZAspc#)

  If DSTpxz# <> 0 Then
    TGdrw# = DYGspc# / DSTpxz#
    GAMdrw# = Atn(TGdrw#)
  Else
    GAMdrw# = Sgn(DYGspc#) * Pi090
  End If


'...................................................................... AbbildungsKoordinaten des Punktes
LFTx& = LFTscc_fly + WDTfoc_fly * ALPdrw#
TOPx& = TOPscc_fly - WDTfoc_fly * GAMdrw#
  

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'*************************************** AUSGABE KLEINER ZIFFERN ****************************************
'
   Sub MntShwWrtNumber(LFTx&, Y&, NBRx%, COLx&)
'                                                        TOPx
'                                                       /
'                                                 LFTx->+ + +
'                                                       + + +
'                                                       + + +
'                                                       + + +
'                                                       + + +
'........................................................................................................

X& = 15 * Int(LFTx& / 15)
Y& = 15 * Int(Y& / 15)

MNT_CTR.DrawWidth = 1

  Select Case NBRx%
    Case 0
      MNT_CTR.Line (X&, Y&)-(X& + 30, Y& + 60), COLx&, B
    
    Case 1
      MNT_CTR.PSet (X& + 15, Y& + 15), COLx&
      MNT_CTR.Line (X& + 30, Y&)-(X& + 30, Y& + 75), COLx&
          
    Case 2
      MNT_CTR.Line (X&, Y&)-(X& + 30, Y& + 60), COLx&, B
      MNT_CTR.PSet (X& + 15, Y& + 30), COLx&
      MNT_CTR.PSet (X&, Y& + 15), 0
      MNT_CTR.PSet (X& + 30, Y& + 45), 0
    
    Case 3
      MNT_CTR.Line (X&, Y&)-(X& + 30, Y& + 60), COLx&, B
      MNT_CTR.PSet (X& + 15, Y& + 30), COLx&
      MNT_CTR.Line (X&, Y& + 15)-(X&, Y& + 60), 0
    
    Case 4
      MNT_CTR.Line (X&, Y&)-(X&, Y& + 30), COLx&
      MNT_CTR.Line (X&, Y& + 30)-(X& + 30, Y& + 30), COLx&
      MNT_CTR.Line (X& + 30, Y& + 15)-(X& + 30, Y& + 75), COLx&
    
    Case 5
      MNT_CTR.Line (X&, Y&)-(X& + 30, Y& + 60), COLx&, B
      MNT_CTR.PSet (X& + 15, Y& + 30), COLx&
      MNT_CTR.PSet (X& + 30, Y& + 15), 0
      MNT_CTR.PSet (X&, Y& + 45), 0
    
    Case 6
      MNT_CTR.Line (X&, Y&)-(X& + 30, Y& + 60), COLx&, B
      MNT_CTR.PSet (X& + 15, Y& + 30), COLx&
      MNT_CTR.PSet (X& + 30, Y& + 15), 0
    
    Case 7
      MNT_CTR.Line (X&, Y&)-(X& + 45, Y&), COLx&
      MNT_CTR.PSet (X& + 30, Y& + 15), COLx&
      MNT_CTR.Line (X& + 15, Y& + 30)-(X& + 15, Y& + 60), COLx&
    
    Case 8
      MNT_CTR.Line (X&, Y&)-(X& + 30, Y& + 60), COLx&, B
      MNT_CTR.PSet (X& + 15, Y& + 30), COLx&
    
    Case 9
      MNT_CTR.Line (X&, Y&)-(X& + 30, Y& + 60), COLx&, B
      MNT_CTR.PSet (X& + 15, Y& + 30), COLx&
      MNT_CTR.PSet (X&, Y& + 45), 0

  End Select

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub MntShwSetLncPoint(SETx%)
'
'........................................................................................................

MNT_CTR.DrawWidth = 1
XX& = LFTstc_loc(0): YY& = TOPstc_loc(0)
              
If Not SETx% = 0 Then CC& = &HFFFFFF
MNT_CTR.Line (XX& - 15, YY& + 30)-(XX& + 15, YY& + 30), CC&
MNT_CTR.Line (XX& - 30, YY& + 45)-(XX& + 30, YY& + 45), CC&

'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'********************************************************************************************************
'
  Sub MntShwSetGeoPoint(SETx%)
'
'........................................................................................................

MNT_CTR.DrawWidth = 1

If Not SETx% = 0 Then CC& = &HFF&

XX& = LFTfly_pnt(NBRfly_pnt): YY& = TOPfly_pnt(NBRfly_pnt)

MNT_CTR.Line (XX& - 60, YY&)-(XX& + 60, YY&), CC&
MNT_CTR.Line (XX&, YY& - 60)-(XX&, YY& + 60), CC&
MNT_CTR.Circle (XX&, YY&), 30, CC&
  
DoEvents

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'****************************** AUSGABE EINES MESS-STATIONS-BEZEICHNERS *********************************
'
  Sub MntShwDrwStcNumber(STCx%, SETx%)
'
'........................................................................................................
        
  
  If SETx% = 1 Then
    TOPstc_nbr(STCx%) = TOPstc_loc(STCx%) - 30
      
      If LFTstc_loc(STCx%) < LFTstc_loc(0) Then
        LFTstc_nbr(STCx%) = LFTstc_loc(STCx%) - 120
      Else
        LFTstc_nbr(STCx%) = LFTstc_loc(STCx%) + 90
      End If
      
    MntShwWrtNumber LFTstc_nbr(STCx%), TOPstc_nbr(STCx%), STCx%, &HFFFF00
  
  Else
      
    MntShwWrtNumber LFTstc_nbr(STCx%), TOPstc_nbr(STCx%), STCx%, 0
      
  End If
  

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'*************************************** AUSGABE EINER MESS-STATION *************************************
'
  Sub MntShwDrwStation(LFTx&, TOPx&, SETx%)
'
'........................................................................................................
        
  If SETx% = 1 Then
          
      Select Case LFTx&
        Case Is < LFTstc_loc(0) - 1500: X1& = LFTx& - 15: X2& = LFTx& + 45
        Case Is > LFTstc_loc(0) + 1500: X1& = LFTx& - 30: X2& = LFTx& + 30
        Case Else:                      X1& = LFTx& - 15: X2& = LFTx& + 30
      End Select
          
    CC& = &HFFFF00
    MNT_CTR.Line (LFTx& - 30, TOPx&)-(LFTx&, TOPx& - 60), CC&
    MNT_CTR.Line (LFTx& + 30, TOPx&)-(LFTx&, TOPx& - 60), CC&
    MNT_CTR.Line (X1&, TOPx& - 75)-(X2&, TOPx& - 75), CC&
  Else
    MNT_CTR.Line (LFTx& - 30, TOPx&)-(LFTx& + 45, TOPx& - 75), 0, BF
  End If
  

'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'*************************************** AUSGABE DER START-STELLE ***************************************
'
  Sub MntShwDrwLncPosition(SETx%)
'
'........................................................................................................
        


  If SETx% = 1 Then
      
    CC& = &HFFFFFF
    MNT_CTR.Line (LFTstc_loc(0), TOPstc_loc(0) - 120)-(LFTstc_loc(0), TOPstc_loc(0) - 30), CC&
    MNT_CTR.Line (LFTstc_loc(0) - 15, TOPstc_loc(0) - 45)-(LFTstc_loc(0) - 15, TOPstc_loc(0)), CC&
    MNT_CTR.Line (LFTstc_loc(0) + 15, TOPstc_loc(0) - 45)-(LFTstc_loc(0) + 15, TOPstc_loc(0)), CC&
  
  Else
      
    MNT_CTR.Line (LFTstc_loc(0) - 30, TOPstc_loc(0) - 150)-(LFTstc_loc(0) + 30, TOPstc_loc(0) + 30), 0, BF
  
  End If

      

'********************************************************************************************************
                                                                                                  End Sub




'********************************************************************************************************
'************************************* ANZEIGE DES START-GELNDES ***************************************
'
  Sub MntShwDrwLncSite()
'
'........................................................................................................


  '..................................................................... ABSTANDS-LINIEN ZUR START-STELLE
  For STCi% = 1 To NBRmsr_stc
    
    '................................................ nderung der RaumKoordinaten pro EntfernungsSchritt
    On Error Resume Next
    KKKxxx# = XXXstc_loc(STCi%) / NBRdst_pnt(STCi%)
    KKKyyy# = YYYstc_loc(STCi%) / NBRdst_pnt(STCi%)
    KKKzzz# = ZZZstc_loc(STCi%) / NBRdst_pnt(STCi%)
    On Error GoTo 0
    
      For PNTi% = 1 To NBRdst_pnt(STCi%) - 1
        XXX# = PNTi% * KKKxxx#: YYY# = PNTi% * KKKyyy#: ZZZ# = PNTi% * KKKzzz#
        MntShwClcDrwPosition XXX#, YYY#, ZZZ#, L&, T&
        MNT_CTR.PSet (L&, T&), &H8000&
      Next PNTi%

    MntShwDrwStation LFTstc_loc(STCi%), TOPstc_loc(STCi%), 1
    MntShwDrwStcNumber STCi%, 1
  Next STCi%

DoEvents
  
'.................................................................. VERBINDUNGLINIEN ZUR NACHBAR-STATION

  '............................................................................... AbbildungsKoordinaten
  For STCi% = 2 To NBRmsr_stc Step 2
    On Error Resume Next
    KKKxxx# = (XXXstc_loc(STCi% - 1) - XXXstc_loc(STCi%)) / NBRstc_pnt(STCi% - 1)
    KKKyyy# = (YYYstc_loc(STCi% - 1) - YYYstc_loc(STCi%)) / NBRstc_pnt(STCi% - 1)
    KKKzzz# = (ZZZstc_loc(STCi% - 1) - ZZZstc_loc(STCi%)) / NBRstc_pnt(STCi% - 1)
    On Error GoTo 0
    
      For PNTi% = 1 To NBRstc_pnt(STCi% - 1)
        XXX# = XXXstc_loc(STCi%) + PNTi% * KKKxxx#
        YYY# = YYYstc_loc(STCi%) + PNTi% * KKKyyy#
        ZZZ# = ZZZstc_loc(STCi%) + PNTi% * KKKzzz#
        MntShwClcDrwPosition XXX#, YYY#, ZZZ#, L&, T&
        
        LFTstc_pnt(STCi% - 1, PNTi%) = L&
        TOPstc_pnt(STCi% - 1, PNTi%) = T&
      Next PNTi%

    KKKxxx# = (XXXstc_loc(STCi% + 1) - XXXstc_loc(STCi%)) / NBRstc_pnt(STCi%)
    KKKyyy# = (YYYstc_loc(STCi% + 1) - YYYstc_loc(STCi%)) / NBRstc_pnt(STCi%)
    KKKzzz# = (ZZZstc_loc(STCi% + 1) - ZZZstc_loc(STCi%)) / NBRstc_pnt(STCi%)
    
    
      For PNTi% = 1 To NBRstc_pnt(STCi%)
        XXX# = XXXstc_loc(STCi%) + PNTi% * KKKxxx#
        YYY# = YYYstc_loc(STCi%) + PNTi% * KKKyyy#
        ZZZ# = ZZZstc_loc(STCi%) + PNTi% * KKKzzz#
        MntShwClcDrwPosition XXX#, YYY#, ZZZ#, L&, T&
        
        LFTstc_pnt(STCi%, PNTi%) = L&
        TOPstc_pnt(STCi%, PNTi%) = T&
      Next PNTi%
    
  Next STCi%

'...................................................................... Letze Station zur ersten Station
KKKxxx# = (XXXstc_loc(1) - XXXstc_loc(NBRmsr_stc)) / NBRstc_pnt(NBRmsr_stc)
KKKyyy# = (YYYstc_loc(1) - YYYstc_loc(NBRmsr_stc)) / NBRstc_pnt(NBRmsr_stc)
KKKzzz# = (ZZZstc_loc(1) - ZZZstc_loc(NBRmsr_stc)) / NBRstc_pnt(NBRmsr_stc)


  For PNTi% = 1 To NBRstc_pnt(NBRmsr_stc)
    XXX# = XXXstc_loc(NBRmsr_stc) + PNTi% * KKKxxx#
    YYY# = YYYstc_loc(NBRmsr_stc) + PNTi% * KKKyyy#
    ZZZ# = ZZZstc_loc(NBRmsr_stc) + PNTi% * KKKzzz#
    MntShwClcDrwPosition XXX#, YYY#, ZZZ#, L&, T&
    
    LFTstc_pnt(NBRmsr_stc, PNTi%) = L&
    TOPstc_pnt(NBRmsr_stc, PNTi%) = T&
  Next PNTi%

  
  '............................................................................................. Anzeige
  For PNTi% = 1 To NBRspt_max Step 2
    
      For STCi% = 2 To NBRmsr_stc Step 2
    
          If PNTi% < NBRstc_pnt(STCi% - 1) Then
            X1& = LFTstc_pnt(STCi% - 1, PNTi%): X2& = LFTstc_pnt(STCi% - 1, PNTi% + 1)
            Y1& = TOPstc_pnt(STCi% - 1, PNTi%): Y2& = TOPstc_pnt(STCi% - 1, PNTi% + 1)
            MNT_CTR.Line (X1&, Y1&)-(X2&, Y2&), &H8000&
          End If
          
          If PNTi% < NBRstc_pnt(STCi%) Then
            X1& = LFTstc_pnt(STCi%, PNTi%): X2& = LFTstc_pnt(STCi%, PNTi% + 1)
            Y1& = TOPstc_pnt(STCi%, PNTi%): Y2& = TOPstc_pnt(STCi%, PNTi% + 1)
            MNT_CTR.Line (X1&, Y1&)-(X2&, Y2&), &H8000&
          End If
        
      Next STCi%
    
    
    
      If NBRmsr_stc Mod 2 = 1 Then
          
          If PNTi% < NBRstc_pnt(NBRmsr_stc) Then
            X1& = LFTstc_pnt(NBRmsr_stc, PNTi%): X2& = LFTstc_pnt(NBRmsr_stc, PNTi% + 1)
            Y1& = TOPstc_pnt(NBRmsr_stc, PNTi%): Y2& = TOPstc_pnt(NBRmsr_stc, PNTi% + 1)
            MNT_CTR.Line (X1&, Y1&)-(X2&, Y2&), &H8000&
          End If
      
      End If
    
  Next PNTi%


'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'************************************ ANZEIGE DER HORIZONT-LINIE ****************************************
'
  Sub MntShwDrwHorizont()
'
'........................................................................................................

GAMspc# = -Atn(YYYobs_fly / DSThrz_mnt)
GAMdrw# = GAMspc# - GMAobs_foc
TOPhrz& = TOPscc_fly - WDTfoc_fly * GAMdrw# - 15
  If TOPhrz& < -60 Then MNT_CTR.HrzPct.Top = -60: Exit Sub
  
  
LFTx& = MNT_CTR.HrzImg.Left

  Select Case LFThrz_stp
    Case Is < 0
      LFThrz_img = LFThrz_img + LFThrz_stp
      LFTx& = 15 * Int(LFThrz_img / 15)
      
      If LFTx& < -(MNT_CTR.HrzImg.Width - MNT_CTR.HrzPct.Width) Then LFThrz_img = 0: LFTx& = LFThrz_img

    Case Is > 0
      LFThrz_img = LFThrz_img + LFThrz_stp
      LFTx& = 15 * Int(LFThrz_img / 15)
      
      If LFTx& > 0 Then LFThrz_img = -(MNT_CTR.HrzImg.Width - MNT_CTR.HrzPct.Width): LFTx& = LFThrz_img
  
  End Select
  
If TOPhrz& <> MNT_CTR.HrzPct.Top Then MNT_CTR.HrzPct.Top = TOPhrz&
If LFTx& <> MNT_CTR.HrzImg.Left Then MNT_CTR.HrzImg.Left = LFTx&

'********************************************************************************************************
                                                                                                  End Sub




'********************************************************************************************************
'**************************************** ANZEIGE DES BESTEN FLUGES *************************************
'
  Sub MntShwFlyLeader()
'
'........................................................................................................
        
     
     If IDXcmp_win = "0" Then Exit Sub

NBRccl_dat = 0
DoEvents
        
        QRYx$ = " SELECT"
QRYx$ = QRYx$ + " xxx, zzz, hgh"
QRYx$ = QRYx$ + " FROM s1x_fly"
QRYx$ = QRYx$ + " WHERE "
QRYx$ = QRYx$ + "  cnt_index =" + Str(IDXcnt_mnt)
QRYx$ = QRYx$ + "  AND cmp_index =" + IDXcmp_win
QRYx$ = QRYx$ + "  AND fly_index =" + IDXfly_win

Set CRSobj_mnt = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)

If Not IsNull(CRSobj_mnt(0)) Then XXXfly_geo = CRSobj_mnt(0)
If Not IsNull(CRSobj_mnt(1)) Then ZZZfly_geo = CRSobj_mnt(1)
If Not IsNull(CRSobj_mnt(2)) Then YYYfly_geo = CRSobj_mnt(2)
CRSobj_mnt.Close
  

MNT_CTR.Cls
MNT_CTR.ClmNamPct.Visible = 0
MNT_CTR.RecLstPct.Visible = 0
DoEvents

STPdst_pnt = 10 '............................................... Entfernung der Punkte der AbstandsLinien
STPvsl_pnt = 20 '................................................. Entfernung der Punkte der VisierLinien
DSThrz_mnt = 3000 '......................................................... Entfernung der HorizontLinie

'..................................................................... AbbildungsPosition der StartStelle
LFTscc_fly = 0.6 * Screen.Width: TOPscc_fly = 0.8 * Screen.Height

MNT_CTR.HrzPct.Move 450, -60, Screen.Width - 750, 30: MNT_CTR.HrzPct.BackColor = 0

MNT_CTR.InfPnlPct.BackColor = 0
MNT_CTR.InfPnlPct.FontSize = 18
MNT_CTR.InfPnlPct.FontBold = 1

  If LCDlng_mnt = "GER" Then
    CPTx$ = "+ BestWert des Wettbewerbs +"
  Else
    CPTx$ = "+ TopFlight of Contest +"
  End If
  
LFTx% = 900: WDTx% = MNT_CTR.InfPnlPct.TextWidth(NAMcmp_win)

If MNT_CTR.InfPnlPct.TextWidth(CPTx$) > WDTx% Then WDTx% = MNT_CTR.InfPnlPct.TextWidth(CPTx$)
HGHx% = 3.5 * MNT_CTR.InfPnlPct.TextHeight(""): TOPx% = 900
MNT_CTR.InfPnlPct.Move LFTx%, TOPx%, WDTx%, HGHx%

TXTx$ = CPTx$
MNT_CTR.InfPnlPct.ForeColor = &HFF&
MNT_CTR.InfPnlPct.CurrentX = 0.5 * (WDTx% - MNT_CTR.InfPnlPct.TextWidth(TXTx$))
MNT_CTR.InfPnlPct.CurrentY = 0
MNT_CTR.InfPnlPct.Print TXTx$;

MNT_CTR.InfPnlPct.Visible = 1
MNT_CTR.InfPnlPct.FontBold = 0
DoEvents

'.................................................................. BERECHNUNG DER ANZEIGE DES FLUGFELDES
'......................................................................... Arrays der AbbildungsParameter
ReDim LFTstc_loc(NBRmsr_stc) As Long, TOPstc_loc(NBRmsr_stc) As Long '...... Koordinaten der MeStationen
ReDim LFTstc_nbr(NBRmsr_stc) As Long, TOPstc_nbr(NBRmsr_stc) As Long '................ StationsBezeichner

'............................................................................. Focus und ObserverPosition
XXXobs_fly = 1500: YYYobs_fly = 1077: ZZZobs_fly = 1400
WDTfoc_fly = Screen.Height
MntShwClcObsDirection

  For STCi% = 1 To NBRmsr_stc
    MntShwClcDrwPosition XXXstc_loc(STCi%), YYYstc_loc(STCi%), ZZZstc_loc(STCi%), L&, T&
    If T& > BTMmax& Then BTMmax& = T&: STCbtm% = STCi%
  Next STCi%
  
MntShwClcDrwPosition XXXfly_geo, YYYfly_geo + 100, ZZZfly_geo, L&, TOPmin&

HGHdrw& = BTMmax& - TOPmin&
WDTfoc_fly = WDTfoc_fly * Screen.Height / HGHdrw&

MntShwClcDrwPosition XXXstc_loc(STCbtm%), YYYstc_loc(STCbtm%), ZZZstc_loc(STCbtm%), L&, T&
TOPscc_fly = TOPscc_fly + Screen.Height - T& - 300


'............................................................................................... HORIZONT
MntShwDrwHorizont
MNT_CTR.HrzPct.Visible = 1


'........................ ABBILDUNGS-KOORDINATEN DER MESS-STATIONEN UND ANZAHL PUNKTE DER ABSTANDS-LINIEN
MntShwClcDrwPosition 0, 0, 0, LFTstc_loc(0), TOPstc_loc(0)

ReDim NBRdst_pnt(NBRmsr_stc) As Integer '............................... Anzahl Punkte der AbstandsLinien
NBRdpt_max = 0 '................................................ Anzahl Punkte der lngsten AbstandsLinie
  
  For STCi% = 1 To NBRmsr_stc
    '........................................................... EndPosition der Abbildung der MeStation
    MntShwClcDrwPosition XXXstc_loc(STCi%), YYYstc_loc(STCi%), ZZZstc_loc(STCi%), L&, T&
    LFTstc_loc(STCi%) = L&: TOPstc_loc(STCi%) = T&
    
    '.................................................................... Anzahl Punkte der AbstandsLinie
    NBRdst_pnt(STCi%) = Int(DSTstc_lnc(STCi%) / STPdst_pnt)
    
    '.......................................................... Hchste Anzahl Punkte einer AbstandsLinie
    If NBRdst_pnt(STCi%) > NBRdpt_max Then NBRdpt_max = NBRdst_pnt(STCi%)
    
  Next STCi%


'.................................................. ABBILDUNGS-KOORDINATEN DER PUNKTE DER ABSTANDS-LINIEN
ReDim LFTdst_pnt(NBRmsr_stc, NBRdpt_max) As Long
ReDim TOPdst_pnt(NBRmsr_stc, NBRdpt_max) As Long
  
  For STCi% = 1 To NBRmsr_stc
    '....................................... Differenzen der AbbildungsKoordinaten MeStation-StartStelle
    DSTlft& = LFTstc_loc(STCi%) - LFTstc_loc(0): DSTtop& = TOPstc_loc(STCi%) - TOPstc_loc(0)
    
    '........................ Umrechnung der Abstnde der Punkte zur StartStelle auf AbbildungKoordinaten
    If DSTstc_lnc(STCi%) <> 0 Then KKKlft# = DSTlft& / DSTstc_lnc(STCi%): KKKtop# = DSTtop& / DSTstc_lnc(STCi%)
    
    '.............................................................................. AbbildungsKoordinaten
    LFTdst_pnt(STCi%, 0) = LFTstc_loc(0): TOPdst_pnt(STCi%, 0) = TOPstc_loc(0)
    
      For PNTi% = 1 To NBRdst_pnt(STCi%)
        WDTpnt& = STPdst_pnt * PNTi% '........................ Entfernung des Punktes von der StartStelle
        LFTdst_pnt(STCi%, PNTi%) = LFTstc_loc(0) + WDTpnt& * KKKlft#
        TOPdst_pnt(STCi%, PNTi%) = TOPstc_loc(0) + WDTpnt& * KKKtop#
      Next PNTi%
    
  Next STCi%
  
'.......................................... ANZAHL PUNKTE DER VERBINDUNGS-LINIEN ZU DEN NACHBAR-STATIONEN
ReDim NBRstc_pnt(NBRmsr_stc) As Integer '......................... Anzahl Punkte der VerbindungsLinien
NBRspt_max = 0 '............................................. Anzahl Punkte der lngsten VerbindungsLinie

  For STCi% = 1 To NBRmsr_stc
    NBRstc_pnt(STCi%) = Int(DSTstc_stc(STCi%, 2) / STPdst_pnt)
    If NBRstc_pnt(STCi%) > NBRspt_max Then NBRspt_max = NBRstc_pnt(STCi%)
  Next STCi%
 
ReDim LFTstc_pnt(NBRmsr_stc, NBRspt_max) As Long
ReDim TOPstc_pnt(NBRmsr_stc, NBRspt_max) As Long

'.................................................................................. MESS-STELLEN ANZEIGEN
AutoRedraw = 1
MntShwDrwLncSite
DoEvents

'................................................................................ BERECHNUNG DER FLUGBAHN
ReDim TMPxxx_spc%(333), TMPzzz_spc%(333), TMPyyy_spc%(333)
   
   
NBRfly_pnt = 0
W0# = Sqr(XXXfly_geo ^ 2 + ZZZfly_geo ^ 2)
Wi# = 0: W# = 0: H# = 0

  Do While Wi# < Pi090
    Wi# = Wi# + 0.02
    Hi# = Sin(Wi#): DWi# = Wi# - W#: DHi# = Hi# - H#
    DD# = Sqr(DWi# ^ 2 + DHi# ^ 2)
          
      If DD# >= 0.1 Then
        H# = Hi#: W# = Wi#: WW# = W# / Pi090
        NBRfly_pnt = NBRfly_pnt + 1
        TMPxxx_spc%(NBRfly_pnt) = XXXfly_geo * WW#
        TMPzzz_spc%(NBRfly_pnt) = ZZZfly_geo * WW#
        TMPyyy_spc%(NBRfly_pnt) = H# * YYYfly_geo
      End If

  Loop
           
ReDim XXXfly_pnt(NBRfly_pnt) As Double
ReDim ZZZfly_pnt(NBRfly_pnt) As Double
ReDim YYYfly_pnt(NBRfly_pnt) As Double
  
  For PNTi% = 1 To NBRfly_pnt
    XXXfly_pnt(PNTi%) = TMPxxx_spc%(PNTi%)
    ZZZfly_pnt(PNTi%) = TMPzzz_spc%(PNTi%)
    YYYfly_pnt(PNTi%) = TMPyyy_spc%(PNTi%)
  Next PNTi%

Erase TMPxxx_spc%(), TMPzzz_spc%(), TMPyyy_spc%()

ReDim LFTfly_pnt(NBRfly_pnt) As Long '................................. Horizontale AbbildungsKoordinaten
ReDim TOPfly_pnt(NBRfly_pnt) As Long '................................... Vertikale AbbildungsKoordinaten


'..................................................................................... ANZEIGE DES FLUGES
If Not MODv3d_mnt = 0 Then S1xPct.Visible = 0
MntShwShwRctFlight

TXTx$ = NAMcmp_win
MNT_CTR.InfPnlPct.ForeColor = &HFFFF00
MNT_CTR.InfPnlPct.CurrentX = 0.5 * (WDTx% - MNT_CTR.InfPnlPct.TextWidth(TXTx$))
MNT_CTR.InfPnlPct.CurrentY = 1.3 * MNT_CTR.InfPnlPct.TextHeight("")
MNT_CTR.InfPnlPct.Print TXTx$;
DoEvents

'...................................................... END-PUNKTE DER PEILUNGS-LINIEN DER MESS-STATIONEN
ReDim XXXvsl_end(NBRmsr_stc) As Double
ReDim YYYvsl_end(NBRmsr_stc) As Double
ReDim ZZZvsl_end(NBRmsr_stc) As Double

ReDim NBRvsl_pnt(NBRmsr_stc) As Integer '............................... Anzahl Punkte der PeilungsLinien
NBRvpt_max = 0 '................................................ Anzahl Punkte der lngsten PeilungsLinie


'.............................................................................................. MeWinkel
ReDim ALPstc_fly(NBRmsr_stc) As Single '...................................... Horizontale PeilungsWinkel
ReDim GMAstc_fly(NBRmsr_stc) As Single '........................................ Vertikale PeilungsWinkel
        
        QRYx$ = " SELECT "
QRYx$ = QRYx$ + " stc_index, hrz_angle, vtc_angle"
QRYx$ = QRYx$ + " FROM s1x_msr "
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_mnt)
QRYx$ = QRYx$ + "  AND cmp_index =" + IDXcmp_win
QRYx$ = QRYx$ + "  AND fly_index =" + IDXfly_win

Set CRSobj_mnt = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)

  Do While Not CRSobj_mnt.EOF
    IDXstc% = CRSobj_mnt(0)
    If Not IsNull(CRSobj_mnt(1)) Then ALPstc_fly(IDXstc%) = CRSobj_mnt(1)
    If Not IsNull(CRSobj_mnt(2)) Then GMAstc_fly(IDXstc%) = CRSobj_mnt(2)
    CRSobj_mnt.MoveNext
  Loop

  
        '..................................................... Grte berechnete Hhe fr jede MeStation
        QRYx$ = " SELECT "
QRYx$ = QRYx$ + " st1_index, st2_index, hgh"
QRYx$ = QRYx$ + " FROM s1x_clc "
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt_mnt)
QRYx$ = QRYx$ + "  AND cmp_index =" + IDXcmp_win
QRYx$ = QRYx$ + "  AND fly_index =" + IDXfly_win

Set CRSobj_mnt = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)

  Do While Not CRSobj_mnt.EOF
    IDXst1% = CRSobj_mnt(0): IDXst2% = CRSobj_mnt(1)
    
      If Not IsNull(CRSobj_mnt(2)) Then
        If CRSobj_mnt(2) > YYYvsl_end(IDXst1%) Then YYYvsl_end(IDXst1%) = CRSobj_mnt(2)
        If CRSobj_mnt(2) > YYYvsl_end(IDXst2%) Then YYYvsl_end(IDXst2%) = CRSobj_mnt(2)
      End If
      
    CRSobj_mnt.MoveNext
  Loop

CRSobj_mnt.Close

  '............................................................................ Koordinaten der EndPunkte
  For STCi% = 1 To NBRmsr_stc
    
      If YYYvsl_end(STCi%) <> 0 Then
        '........................................................ Umrechnung der VisierWinkel in Bogenma
        On Error Resume Next
        GMAsfl_bgm# = Pi090 * GMAstc_fly(STCi%) / RCTstc_vtc(STCi%)
        
        '........................................ Lnge der Projektion der PeilungsLinie auf die XZ-Ebene
        DSTpxz# = Abs(YYYvsl_end(STCi%) / Tan(GMAsfl_bgm#))
        
        '................................................ Horizontaler PeilungsWinkel relativ zur Z-Achse
        ALPsfl_bgm# = Pi090 * ALPstc_fly(STCi%) / RCTstc_hrz(STCi%)
        PHIstc_fly# = Pi180 + OMGstl_bgm(STCi%) + ALPsfl_bgm#
        
        '..................................... Position des EndePunktes der PeilungsLinie in der XZ-Ebene
        XXXvsl_end(STCi%) = XXXstc_loc(STCi%) + DSTpxz# * Sin(PHIstc_fly#)
        ZZZvsl_end(STCi%) = ZZZstc_loc(STCi%) + DSTpxz# * Cos(PHIstc_fly#)
        On Error GoTo 0
        
        
        '........................................................................ Lnge der PeilungsLinie
        DX# = XXXvsl_end(STCi%) - XXXstc_loc(STCi%)
        DZ# = ZZZvsl_end(STCi%) - ZZZstc_loc(STCi%)
        DY# = YYYvsl_end(STCi%) - YYYstc_loc(STCi%)
        DSTvsl# = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)
                
        '................................................................ Anzahl Punkte der PeilungsLinie
        NBRvsl_pnt(STCi%) = Int(DSTvsl# / STPvsl_pnt) + 2
        If NBRvsl_pnt(STCi%) < 9 Then NBRvsl_pnt(STCi%) = 9
        If NBRvsl_pnt(STCi%) > NBRvpt_max Then NBRvpt_max = NBRvsl_pnt(STCi%)
        
      End If
      
  Next STCi%


'.................................................... AbbildungsKoordinaten der Punkte der PeilungsLinien
ReDim LFTvsl_pnt(STCi%, NBRvpt_max) As Long
ReDim TOPvsl_pnt(STCi%, NBRvpt_max) As Long
  
MntShwDrwVisLines '........................................................... Anzeige der PeilungsLinien

'....................................................................................... Anzeige der Hhe
TXTx$ = LTrim(Str(YYYfly_geo)) + " m"
MNT_CTR.InfPnlPct.ForeColor = &HFFFFFF
MNT_CTR.InfPnlPct.FontSize = 16
MNT_CTR.InfPnlPct.CurrentX = 0.5 * (WDTx% - MNT_CTR.InfPnlPct.TextWidth(TXTx$))
MNT_CTR.InfPnlPct.CurrentY = 2.8 * MNT_CTR.InfPnlPct.TextHeight("")
MNT_CTR.InfPnlPct.Print TXTx$;


'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'******************************************* RAKETEN-FLUG ***********************************************
'
   Sub MntShwShwRctFlight()
'
'........................................................................................................


MntShwDrwLncPosition 0
MntShwSetLncPoint 1
DoEvents


X2& = 15 * Int(LFTstc_loc(0) / 15): Y2& = 15 * Int(TOPstc_loc(0) / 15)
LFTfly_pnt(0) = X2&: TOPfly_pnt(0) = Y2&
CC& = &HFF&

  For PNTi% = 1 To NBRfly_pnt
    X1& = X2&: Y1& = Y2&
    
    XX# = XXXfly_pnt(PNTi%): YY# = YYYfly_pnt(PNTi%): ZZ# = ZZZfly_pnt(PNTi%)
    MntShwClcDrwPosition XX#, YY#, ZZ#, X2&, Y2&
    LFTfly_pnt(PNTi%) = X2&: TOPfly_pnt(PNTi%) = Y2&
    
    DX# = (X2& - X1&) / 3: DY# = (Y2& - Y1&) / 3
        
    Do: Loop Until Timer - T# > 0.07: T# = Timer
    MNT_CTR.DrawWidth = 2
      
    MNT_CTR.PSet (X1&, Y1&), CC&: MNT_CTR.PSet (X1& + DX#, Y1& + DY#), &HFFFFFF
    DoEvents
    
    Do: Loop Until Timer - T# > 0.07: T# = Timer
    MNT_CTR.DrawWidth = 2
    
    MNT_CTR.PSet (X1& + DX#, Y1& + DY#), 0
    MNT_CTR.PSet (X1& + 2 * DX#, Y1& + 2 * DY#), &HFFFFFF
    MNT_CTR.DrawWidth = 1
    MNT_CTR.PSet (X1& + DX#, Y1& + DY#), CC&
    
    DoEvents
    
    Do: Loop Until Timer - T# > 0.07: T# = Timer
    MNT_CTR.DrawWidth = 2
      
    MNT_CTR.PSet (X1& + 2 * DX#, Y1& + 2 * DY#), 0
    MNT_CTR.PSet (X2&, Y2&), &HFFFFFF
    MNT_CTR.DrawWidth = 1
    MNT_CTR.PSet (X1& + 2 * DX#, Y1& + 2 * DY#), CC&
    
    DoEvents
  Next PNTi%
   
MNT_CTR.DrawWidth = 2
MNT_CTR.PSet (X2&, Y2&), 0
   
'................................................................................................ Auswurf
MntShwSetGeoPoint 1

'********************************************************************************************************
                                                                                                  End Sub











'********************************************************************************************************
'************************************ ANZEIGE DER VISIER-LINIEN *****************************************
'
  Sub MntShwDrwVisLines()
'
'........................................................................................................


  '................................................................. Berechnung der AbbildungsKoordinaten
  For STCi% = 1 To NBRmsr_stc
  
      If YYYvsl_end(STCi%) <> 0 Then
        KKKxxx# = (XXXvsl_end(STCi%) - XXXstc_loc(STCi%)) / NBRvsl_pnt(STCi%)
        KKKyyy# = (YYYvsl_end(STCi%) - YYYstc_loc(STCi%)) / NBRvsl_pnt(STCi%)
        KKKzzz# = (ZZZvsl_end(STCi%) - ZZZstc_loc(STCi%)) / NBRvsl_pnt(STCi%)
        
        LFTvsl_pnt(STCi%, 0) = LFTstc_loc(STCi%): TOPvsl_pnt(STCi%, 0) = TOPstc_loc(STCi%) - 90
    
    
          For PNTi% = 1 To NBRvsl_pnt(STCi%)
            XXX# = XXXstc_loc(STCi%) + PNTi% * KKKxxx#
            YYY# = YYYstc_loc(STCi%) + PNTi% * KKKyyy#
            ZZZ# = ZZZstc_loc(STCi%) + PNTi% * KKKzzz#
            
            MntShwClcDrwPosition XXX#, YYY#, ZZZ#, L&, T&
            LFTvsl_pnt(STCi%, PNTi%) = L&
            TOPvsl_pnt(STCi%, PNTi%) = T& - 90
          Next PNTi%
      
      End If
    
  Next STCi%

  '........................................................................... Anzeige der PeilungsLinien
  For PNTi% = 1 To NBRvpt_max
  
      
      For STCi% = 1 To NBRmsr_stc
        
          If PNTi% < NBRvsl_pnt(STCi%) - 1 Then
            XX& = LFTvsl_pnt(STCi%, PNTi%): YY& = TOPvsl_pnt(STCi%, PNTi%)
            DX1% = 0.2 * (LFTvsl_pnt(STCi%, PNTi% - 1) - XX&)
            DY1% = 0.2 * (TOPvsl_pnt(STCi%, PNTi% - 1) - YY&)
            DX2% = 0.6 * (LFTvsl_pnt(STCi%, PNTi% - 1) - XX&)
            DY2% = 0.6 * (TOPvsl_pnt(STCi%, PNTi% - 1) - YY&)
              
              If Abs(DX2%) + Abs(DY2%) > 45 Then
                MNT_CTR.Line (XX&, YY&)-(XX& + DX2%, YY& + DY2%), &H8080&
                MNT_CTR.Line (XX&, YY&)-(XX& + DX1%, YY& + DY1%), &HFFFF&
              Else
                MNT_CTR.Line (XX&, YY&)-(XX& + DX2%, YY& + DY2%), &HFFFF&
              End If
              
          End If
        
      Next STCi%
  
  Next PNTi%
  

'********************************************************************************************************
                                                                                                  End Sub








































